state:filter_interactions(function(i)
  return "This level does not allow interaction."
end)
function only_wire_filter(i)
  return i == PlayerInteraction.wire or i == PlayerInteraction.cancel
end

local default_vertical = -0.4
set_default_vertical(default_vertical)
function tutorial_routine()
  return coroutine.wrap(function()
    state:suppress_toolbar_menu();
    state:suppress_transport_menu();
    state:suppress_interface_hints();
    set_user_input_filter(only_wire_filter)
    embed(announce("This factory already works.", 3, 0.1, captured_cancel()))
    embed(pause(0.2))
    embed(ramp(5, do_all(
      announce_lambda("It demonstrates one fact:", 0.08),
      announce_lambda("Sensors cannot see the sides of piston arms.", 0.1, default_vertical - 0.11)
    ), captured_cancel()))
    set_user_input_filter(only_play_or_speed_or_cancel_filter)
    state:suppress_transport_menu(false);
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
  end)
end

draw_interpreted_routine(tutorial_routine())
